<!DOCTYPE HTML> 
<html lang="lv">
<head>
<meta charset="UTF-8">
<title>Personas tabula</title>

<style>
table, td, th {
	border: 1px solid #595959;
	border-collapse: collapse;
	text-align: center;
}
td, th {
	padding: 5px;
	width: 100px;
}
th {
	background: #f0e6cc;
	cursor: pointer; /* Norāda, ka kolonnu var kārtot */
}
tr:nth-child(even) {
	background: #fbf8f0;
}
tr:nth-child(odd) {
	background: #fefcf9;
}
input[type="text"] {
	margin: 5px;
	padding: 4px;
}
#result {
	margin-top: 15px;
	font-weight: bold;
}
</style>
</head>

<body>
<h2>Personu dati</h2>

<!-- Vispārējā meklēšana (filtrē visā tabulā) -->
<input type="text" id="searchInput" placeholder="Meklēt visā tabulā..." onkeyup="searchTable()">

<!-- Katras kolonnas filtrs -->
<div id="columnFilters">
  <input type="text" id="filterName" placeholder="Filtrēt vārdu" onkeyup="filterByColumn(0)">
  <input type="text" id="filterSurname" placeholder="Filtrēt uzvārdu" onkeyup="filterByColumn(1)">
  <input type="text" id="filterDate" placeholder="Filtrēt datumu" onkeyup="filterByColumn(2)">
  <input type="text" id="filterCar" placeholder="Filtrēt auto" onkeyup="filterByColumn(3)">
</div>

<!-- Tabula ar datiem -->
<table id="dataTable">
<thead>
	<tr>
		<td colspan="5">Personas</td>
		<td colspan="3">Pārvietošanās</td>
		<td rowspan="2" colspan="2">Darbības</td>
	</tr>
	<tr>
		<th onclick="sortTable(0)">Vārds</th>
		<th onclick="sortTable(1)">Uzvārds</th>
		<th onclick="sortTable(2)">Datums</th>
		<th onclick="sortTable(3)">Auto</th>
		<th onclick="sortTable(4)">Ritenis</th>
		<th onclick="sortTable(5)">Mašīna</th>
		<th onclick="sortTable(6)">Laiva</th>
		<th onclick="sortTable(7)">WEB Valoda</th>
	</tr>
</thead>

<tbody>
<?php
include 'con.php';

$sql = "SELECT `id`, `vards`, `uzvards`, `dati`, `car`, `transports1`, `transports2`, `transports3`, `prvalodas` FROM `Table1`";
$result = $conn->query($sql);

while ($row = $result->fetch_assoc()) { ?>
	<tr>
		<td><?= htmlspecialchars($row["vards"]) ?></td>
		<td><?= htmlspecialchars($row["uzvards"]) ?></td>
		<td><?= htmlspecialchars($row["dati"]) ?></td>
		<td><?= htmlspecialchars($row["car"]) ?></td>
		<td><?= htmlspecialchars($row["transports1"]) ?></td>
		<td><?= htmlspecialchars($row["transports2"]) ?></td>
		<td><?= htmlspecialchars($row["transports3"]) ?></td>
		<td><?= htmlspecialchars($row["prvalodas"]) ?></td>
		<td>
			<!-- Dzēšanas poga, kas izmanto AJAX un nereloadē lapu -->
			<button onclick="deleteRecord(<?= $row['id'] ?>)">Dzēst</button>
		</td>
		<td>
			<form action="fails1.php" method="get">
				<input type="hidden" name="id" value="<?= $row['id'] ?>">
				<input type="submit" value="Labot">
			</form>
		</td>
	</tr>
<?php } ?>
</tbody>
</table>

<!-- Rezultāta laukums (rāda paziņojumu par dzēšanu) -->
<div id="result"></div>

<!-- Pievienojam ārējo JS failu -->
<script src="table.js"></script>

</body>
</html>
